using UnityEngine;
using System;

public class CanonScript : MonoBehaviour {
	
	internal float alpha = 0f;
	internal float betha = 15.0f;
	private float power = 0f;
	
	private float powerMax = 5f;
	
	bool fireDown = false;
	private bool fired = false;
	
	DateTime fireTime = DateTime.Now;
	
	public float angleStep;
	public GameObject rocket;
	
	private Transform m_Vidurys;
	private Transform m_Interm;
	private GUITexture m_UI;

	void Start () {
		m_Vidurys = transform.Find("Padas/Vidurys");
		m_Interm = transform.Find("Padas/Vidurys/Interm");
		m_UI = transform.Find("/UI/PowerBar").guiTexture;
	}
	
	void Update () {
		float step = angleStep * Time.deltaTime;
		if (Input.GetKey("a"))
			alpha -= step;
			
		if (Input.GetKey("d"))
			alpha += step;
			
		if (Input.GetKey("s"))
			betha -= step;
			
		if (Input.GetKey("w"))
			betha += step;
			
		betha = Mathf.Clamp(betha, -5.0f, 120.0f);
			
		if (!fired) {
			if (Input.GetKeyDown("space"))
			{
				fireTime = DateTime.Now;
				fireDown = true;
			}
		} else {
			power = 0;
		}
			
		if (!fired && Input.GetKey("space"))
		{
			TimeSpan duration = DateTime.Now - fireTime;
			power = powerMax * ((int)duration.TotalMilliseconds % 4000) / 4000.0f;
		}
		
		if (fireDown && Input.GetKeyUp("space"))
			FireRocket();
		
		m_Vidurys.localRotation = Quaternion.AngleAxis (alpha, Vector3.up);
		m_Interm.localRotation = Quaternion.AngleAxis (betha, -Vector3.right);
		
		Rect inset = m_UI.pixelInset;
		inset.width = 22 + power/powerMax * (256-22);
		m_UI.pixelInset = inset;
		m_UI.color = new Color(0.5f,0.5f,0.5f, fired ? 0.1f : 0.5f);
	}
	
	public void FireRocket()
	{
		fired = true;
		fireDown = false;
		GameObject rocketClone  = (GameObject)Instantiate(rocket, m_Interm.position + m_Interm.forward * 0.3f, m_Interm.rotation);
		RocketScript rscript = (RocketScript)rocketClone.GetComponent(typeof(RocketScript));
		rscript.speedDirection = m_Interm.forward;
		rscript.speed = 1.0f + power;
		rscript.Init();
	}
}
